from tensorflow.python.keras.utils.data_utils import get_file
import os 
import numpy as np
# from google_drive_downloader import GoogleDriveDownloader as gdd

# credit for https://www.microsoft.com/en-us/download/details.aspx?id=54765

IMG_SIZE = 128

def load_data(path):
    save_data_path = os.path.join(path,'melanoma_train_X.npy')
    save_label_path = os.path.join(path, 'melanoma_train_Y.npy')
    train_data = np.load(save_data_path)
    train_label = np.load(save_label_path)
    train_data = np.transpose(train_data, (0,3,2,1))
    save_data_path = os.path.join(path,'melanoma_test_X.npy')
    save_label_path = os.path.join(path, 'melanoma_test_Y.npy')
    test_data = np.load(save_data_path)
    test_label = np.load(save_label_path)
    test_data = np.transpose(test_data, (0,3,2,1))
    
    return train_data, train_label, test_data, test_label


def Melanoma():
    
    
    train_X, train_Y,  test_X, test_Y = load_data('/dual_data/not_backed_up/dixzhu/melanoma/')

    # convert data type
    train_X, train_Y = train_X.astype(float), train_Y.astype(np.int32) 
    test_X, test_Y = test_X.astype(float), test_Y.astype(np.int32) 
    
    return  (train_X, train_Y), (test_X, test_Y) 


